// gen-tiny-swords.js
const fs = require('fs');
const path = require('path');

// ---- Réglages
const INDEX_PATH = path.join(__dirname, 'assets/Tiny_Swords/tiny_swords_index.json'); // adapter si besoin
const ROOT = "assets/Tiny_Swords";
const OUT = path.join("sprites/loader", 'tiny_swords.json');

// ---- 1. Lire le fichier d'index
const indexData = JSON.parse(fs.readFileSync(INDEX_PATH, 'utf-8'));
const jsonFiles = indexData.path;

// ---- 2. Fusionner tous les sprites dans un seul tableau
const allSprites = [];

jsonFiles.forEach(relPath => {
    const spritePath = path.join(ROOT, relPath);
    if (!fs.existsSync(spritePath)) {
        console.warn(`Fichier non trouvé : ${spritePath}`);
        return;
    }
    const data = JSON.parse(fs.readFileSync(spritePath, 'utf-8'));
    if (Array.isArray(data.sprites)) {
        allSprites.push(...data.sprites);
    } else if (data.sprites) {
        allSprites.push(data.sprites);
    } else {
        allSprites.push(data);
    }
});

// ---- 3. Ecrire le résultat final
fs.writeFileSync(OUT, JSON.stringify({sprites: allSprites}, null, 2), 'utf-8');
console.log(`tiny_swords.json généré avec ${allSprites.length} sprites.`);
