import {Box, IconButton, TextField, Tooltip} from "@mui/material";
import VisibilityIcon from "@mui/icons-material/Visibility";
import VisibilityOffIcon from "@mui/icons-material/VisibilityOff";
import ArrowUpwardIcon from "@mui/icons-material/ArrowUpward";
import ArrowDownwardIcon from "@mui/icons-material/ArrowDownward";
import DeleteIcon from "@mui/icons-material/Delete";
import AddIcon from "@mui/icons-material/Add";

type Props = {
    map: any;
    activeLayerId: string;
    setActiveLayer: (id: string) => void;
    onAddLayer: () => void;
    onRemoveLayer: (id: string) => void;
    onRenameLayer: (id: string, name: string) => void;
    onToggleLayer: (id: string) => void;
    onMoveLayer: (id: string, dir: "up" | "down") => void;
};

export default function LayerPanel(props: Props) {
    return (
        <Box sx={{minWidth: 180, maxWidth: 220, p: 2, bgcolor: "#fafbfe", borderRight: "1px solid #ccc"}}>
            <Box sx={{mb: 2, display: "flex", alignItems: "center", justifyContent: "space-between"}}>
                <b>Layers</b>
                <Tooltip title="Ajouter une couche">
                    <IconButton size="small" onClick={props.onAddLayer}><AddIcon fontSize="small"/></IconButton>
                </Tooltip>
            </Box>
            {props.map.layers.map((l, idx) => (
                <Box
                    key={l.id}
                    sx={{
                        display: "flex", alignItems: "center", p: 1, mb: 1, borderRadius: 1,
                        bgcolor: props.activeLayerId === l.id ? "#e8eefc" : "#fff",
                        boxShadow: props.activeLayerId === l.id ? "0 2px 8px #1976d222" : undefined,
                        border: "1px solid #bbb"
                    }}
                    onClick={() => props.setActiveLayer(l.id)}
                >
                    <Tooltip title={l.visible ? "Cacher" : "Afficher"}>
                        <IconButton size="small" onClick={e => {
                            e.stopPropagation();
                            props.onToggleLayer(l.id);
                        }}>
                            {l.visible ? <VisibilityIcon fontSize="small"/> : <VisibilityOffIcon fontSize="small"/>}
                        </IconButton>
                    </Tooltip>
                    <TextField
                        value={l.name}
                        size="small"
                        variant="standard"
                        onChange={e => props.onRenameLayer(l.id, e.target.value)}
                        sx={{width: 80, mx: 1}}
                    />
                    <Tooltip title="Monter">
                        <IconButton size="small" disabled={idx === 0} onClick={e => {
                            e.stopPropagation();
                            props.onMoveLayer(l.id, "up")
                        }}>
                            <ArrowUpwardIcon fontSize="small"/>
                        </IconButton>
                    </Tooltip>
                    <Tooltip title="Descendre">
                        <IconButton size="small" disabled={idx === props.map.layers.length - 1} onClick={e => {
                            e.stopPropagation();
                            props.onMoveLayer(l.id, "down")
                        }}>
                            <ArrowDownwardIcon fontSize="small"/>
                        </IconButton>
                    </Tooltip>
                    <Tooltip title="Supprimer">
                        <IconButton size="small" color="error" onClick={e => {
                            e.stopPropagation();
                            props.onRemoveLayer(l.id);
                        }}>
                            <DeleteIcon fontSize="small"/>
                        </IconButton>
                    </Tooltip>
                </Box>
            ))}
        </Box>
    );
}
