import { contextBridge, ipcRenderer } from "electron";
import { electronAPI } from '@electron-toolkit/preload'

const api = {
  getProducts: () => ipcRenderer.invoke('get-products'),
  addProduct: (prod) => ipcRenderer.invoke('add-product', prod),
  deleteProduct: (id) => ipcRenderer.invoke('delete-product', id),
  sellCart: (items, printerIp) => ipcRenderer.invoke('sell-cart', items, printerIp),
  getSales: () => ipcRenderer.invoke('get-sales'),
  printTicket: (xml, url) => ipcRenderer.invoke('print-ticket', xml, url)
}


// Use `contextBridge` APIs to expose Electron APIs to
// renderer only if context isolation is enabled, otherwise
// just add to the DOM global.
if (process.contextIsolated) {
  try {
    contextBridge.exposeInMainWorld('electron', electronAPI)
    contextBridge.exposeInMainWorld('api', api)
  } catch (error) {
    console.error(error)
  }
} else {
  // @ts-ignore (define in dts)
  window.electron = electronAPI
  // @ts-ignore (define in dts)
  window.api = api
}
