const slides = document.querySelectorAll('.slide');
let current = 0;
const prevBtn = document.getElementById('prevBtn');
const nextBtn = document.getElementById('nextBtn');

// Pour focus la slide (a11y)
function showSlide(idx) {
    slides.forEach((slide, i) => {
        slide.classList.remove('active', 'to-left', 'to-right');
        if (i === idx) slide.classList.add('active');
        else if (i < idx) slide.classList.add('to-left');
        else slide.classList.add('to-right');
    });
    prevBtn.style.display = (idx === 0) ? 'none' : '';
    nextBtn.style.display = (idx === slides.length - 1) ? 'none' : '';
    slides[idx].focus && slides[idx].focus();
}

showSlide(current);

prevBtn.onclick = () => {
    if (current > 0) {
        current--;
        showSlide(current);
    }
};
nextBtn.onclick = () => {
    if (current < slides.length - 1) {
        current++;
        showSlide(current);
    }
};

// Option : faire clignoter "suivant" si on est en bas de la slide longue
slides.forEach((slide, idx) => {
    slide.addEventListener('scroll', () => {
        if (idx !== current) return;
        const isAtBottom = slide.scrollHeight - slide.scrollTop - slide.clientHeight < 24;
        nextBtn.classList.toggle('attention', isAtBottom && current < slides.length - 1);
    });
});

// Quiz : même code qu’avant mais pour 10 questions !
const quizForm = document.getElementById('quiz-form');
if (quizForm) {
    quizForm.addEventListener('submit', function (e) {
        e.preventDefault();
        const answers = {
            q1: 'b',
            q2: 'a',
            q3: 'b',
            q4: 'a',
            q5: 'a',
            q6: 'a',
            q7: 'a',
            q8: 'a',
            q9: 'a',
            q10: 'a'
        };
        let score = 0;
        for (let key in answers) {
            const val = quizForm.querySelector(`[name=${key}]:checked`);
            if (val && val.value === answers[key]) score++;
        }
        let msg;
        if (score === 10) msg = "🌟 Incroyable, tu maîtrises parfaitement Merise ! (10/10)";
        else if (score >= 8) msg = "👏 Excellente maîtrise ! ( " + score + " /10)";
        else if (score >= 5) msg = "✅ Pas mal, mais encore un effort ! (" + score + "/10)";
        else msg = "💡 Revois les slides et réessaie ! (" + score + "/10)";
        document.getElementById('quiz-result').textContent = msg;
    });
}
