import { contextBridge, ipcRenderer } from 'electron';

contextBridge.exposeInMainWorld('electronAPI', {
  getProducts: () => ipcRenderer.invoke('get-products'),
  addProduct: (prod: { name: string; price: number; stock: number }) => ipcRenderer.invoke('add-product', prod),
  deleteProduct: (id: string) => ipcRenderer.invoke('delete-product', id),
  sellCart: (items: {
    id: string;
    qty: number
  }[], printerIp: string) => ipcRenderer.invoke('sell-cart', items, printerIp),
  getSales: () => ipcRenderer.invoke('get-sales'),
});
console.log('Preload chargé !');

