"use strict";
const electron = require("electron");
const preload = require("@electron-toolkit/preload");
const api = {
  getProducts: () => electron.ipcRenderer.invoke("get-products"),
  addProduct: (prod) => electron.ipcRenderer.invoke("add-product", prod),
  deleteProduct: (id) => electron.ipcRenderer.invoke("delete-product", id),
  sellCart: (items, printerIp) => electron.ipcRenderer.invoke("sell-cart", items, printerIp),
  getSales: () => electron.ipcRenderer.invoke("get-sales"),
  printTicket: (xml, url) => electron.ipcRenderer.invoke("print-ticket", xml, url)
};
if (process.contextIsolated) {
  try {
    electron.contextBridge.exposeInMainWorld("electron", preload.electronAPI);
    electron.contextBridge.exposeInMainWorld("api", api);
  } catch (error) {
    console.error(error);
  }
} else {
  window.electron = preload.electronAPI;
  window.api = api;
}
