import {
  __privateAdd,
  __privateGet,
  __privateSet,
  __publicField
} from "./chunk-OCBYBPSH.js";

// node_modules/lowdb/lib/adapters/Memory.js
var _data;
var Memory = class {
  constructor() {
    __privateAdd(this, _data, null);
  }
  read() {
    return Promise.resolve(__privateGet(this, _data));
  }
  write(obj) {
    __privateSet(this, _data, obj);
    return Promise.resolve();
  }
};
_data = new WeakMap();
var _data2;
var MemorySync = class {
  constructor() {
    __privateAdd(this, _data2, null);
  }
  read() {
    return __privateGet(this, _data2) || null;
  }
  write(obj) {
    __privateSet(this, _data2, obj);
  }
};
_data2 = new WeakMap();

// node_modules/lowdb/lib/core/Low.js
function checkArgs(adapter, defaultData) {
  if (adapter === void 0)
    throw new Error("lowdb: missing adapter");
  if (defaultData === void 0)
    throw new Error("lowdb: missing default data");
}
var Low = class {
  constructor(adapter, defaultData) {
    __publicField(this, "adapter");
    __publicField(this, "data");
    checkArgs(adapter, defaultData);
    this.adapter = adapter;
    this.data = defaultData;
  }
  async read() {
    const data = await this.adapter.read();
    if (data)
      this.data = data;
  }
  async write() {
    if (this.data)
      await this.adapter.write(this.data);
  }
  async update(fn) {
    fn(this.data);
    await this.write();
  }
};
var LowSync = class {
  constructor(adapter, defaultData) {
    __publicField(this, "adapter");
    __publicField(this, "data");
    checkArgs(adapter, defaultData);
    this.adapter = adapter;
    this.data = defaultData;
  }
  read() {
    const data = this.adapter.read();
    if (data)
      this.data = data;
  }
  write() {
    if (this.data)
      this.adapter.write(this.data);
  }
  update(fn) {
    fn(this.data);
    this.write();
  }
};
export {
  Low,
  LowSync,
  Memory,
  MemorySync
};
//# sourceMappingURL=lowdb.js.map
