import type {SpriteEntry} from "../_types/spriteTypes";

// Explore window.Sprites et génère une liste plate
export function getAllSpritesFromLib(Sprites: any): SpriteEntry[] {
    const result: SpriteEntry[] = [];

    function walk(obj: any, prefix: string[] = []) {
        for (const k in obj) {
            if (!obj.hasOwnProperty(k)) continue;
            const value = obj[k];
            if (typeof value === "function") {
                result.push({
                    key: [...prefix, k].join("."),
                    label: [...prefix, k].join(" "),
                    category: prefix[0] || "other",
                    type: prefix[1] || "other",
                    drawFn: value,
                    animated: k !== "default",
                });
            } else if (typeof value === "object" && value !== null) {
                walk(value, [...prefix, k]);
            }
        }
    }

    walk(Sprites);
    return result;
}
