import {Box, Button, TextField, Stack, Slider, Tooltip} from "@mui/material";
import DownloadIcon from "@mui/icons-material/Download";
import UploadIcon from "@mui/icons-material/Upload";
import ImageIcon from "@mui/icons-material/Image";
import UndoIcon from "@mui/icons-material/Undo";
import RedoIcon from "@mui/icons-material/Redo";
import DeleteIcon from "@mui/icons-material/Delete";
import LayersClearIcon from "@mui/icons-material/LayersClear";
import HelpIcon from "@mui/icons-material/Help";

type Props = {
    mapName: string;
    setMapName: (name: string) => void;
    onExportJson: () => void;
    onExportPng: () => void;
    onImport: (file: File) => void;
    onUndo: () => void;
    onRedo: () => void;
    canUndo: boolean;
    canRedo: boolean;
    onClearAll: () => void;
    onClearLayer: () => void;
    zoom: number;
    setZoom: (v: number) => void;
    onShowHelp: () => void;
};

export default function ToolBar(props: Props) {
    const {
        mapName, setMapName, onExportJson, onExportPng, onImport,
        onUndo, onRedo, canUndo, canRedo,
        onClearAll, onClearLayer,
        zoom, setZoom,
        onShowHelp
    } = props;
    return (
        <Box sx={{p: 2, display: "flex", alignItems: "center", gap: 2, bgcolor: "#f7fafd"}}>
            <TextField
                label="Nom de la map"
                value={mapName}
                onChange={e => setMapName(e.target.value)}
                size="small"
                sx={{width: 200}}
            />
            <Stack direction="row" spacing={1}>
                <Button variant="outlined" onClick={onUndo} startIcon={<UndoIcon/>} disabled={!canUndo}>Annuler</Button>
                <Button variant="outlined" onClick={onRedo} startIcon={<RedoIcon/>}
                        disabled={!canRedo}>Rétablir</Button>
                <Button variant="outlined" color="error" onClick={onClearAll} startIcon={<DeleteIcon/>}>Effacer
                    tout</Button>
                <Button variant="outlined" color="warning" onClick={onClearLayer} startIcon={<LayersClearIcon/>}>Effacer
                    couche</Button>
                <Button variant="contained" startIcon={<DownloadIcon/>} onClick={onExportJson}>Export JSON</Button>
                <Button variant="contained" startIcon={<ImageIcon/>} onClick={onExportPng}>Export PNG</Button>
                <Button variant="outlined" startIcon={<UploadIcon/>} component="label">
                    Import
                    <input hidden type="file" accept=".json" onChange={e => {
                        if (e.target.files && e.target.files[0]) onImport(e.target.files[0]);
                    }}/>
                </Button>
                <Tooltip title="Aide & astuces">
                    <Button variant="text" onClick={onShowHelp}><HelpIcon/></Button>
                </Tooltip>
            </Stack>
            <Box sx={{display: "flex", alignItems: "center", ml: 3, minWidth: 120}}>
                <span style={{fontSize: 14, marginRight: 8}}>Zoom</span>
                <Slider
                    min={0.5}
                    max={2}
                    step={0.05}
                    value={zoom}
                    onChange={(_, v) => props.setZoom(Number(v))}
                    size="small"
                    sx={{width: 90}}
                />
                <span style={{marginLeft: 8}}>{Math.round(zoom * 100)}%</span>
            </Box>
        </Box>
    );
}
