export type Cell = null | {
    sprite: string; // le key du SpriteEntry
};

export type MapLayer = {
    id: string;
    name: string;
    visible: boolean;
    cells: (Cell)[][];
};

export type MapFile = {
    name: string;
    width: number;
    height: number;
    tileSize: number;
    layers: MapLayer[];
    meta?: Record<string, any>;
};
