// 1. Préload
(async () => {
    await Sprites.preloadAll();

    const spriteDraws = [
        (ctx, x, y) => Sprites.deco.Mushroom01.default(ctx, x+64, y+64, {w: 64, h: 64}),
        (ctx, x, y) => Sprites.deco.Mushroom02.default(ctx, x+64, y+64, {w: 64, h: 64}),
        (ctx, x, y) => Sprites.deco.Mushroom03.default(ctx, x+64, y+64, {w: 64, h: 64}),
        (ctx, x, y) => Sprites.deco.Mushroom04.default(ctx, x+64, y+64, {w: 64, h: 64}),
        (ctx, x, y) => Sprites.deco.Mushroom05.default(ctx, x+64, y+64, {w: 64, h: 64}),
        (ctx, x, y) => Sprites.deco.Mushroom06.default(ctx, x+64, y+64, {w: 64, h: 64}),
        (ctx, x, y) => Sprites.deco.Mushroom07.default(ctx, x+64, y+64, {w: 64, h: 64}),
        (ctx, x, y) => Sprites.deco.Mushroom08.default(ctx, x+64, y+64, {w: 64, h: 64}),
        (ctx, x, y) => Sprites.deco.Mushroom09.default(ctx, x+64, y+64, {w: 64, h: 64}),
        (ctx, x, y) => Sprites.deco.Mushroom10.default(ctx, x+64, y+64, {w: 64, h: 64}),
        (ctx, x, y) => Sprites.deco.Mushroom11.default(ctx, x+64, y+64, {w: 64, h: 64}),
        (ctx, x, y) => Sprites.deco.Mushroom12.default(ctx, x+64, y+64, {w: 64, h: 64}),
        (ctx, x, y) => Sprites.deco.Mushroom13.default(ctx, x+64, y+64, {w: 64, h: 64}),
        (ctx, x, y) => Sprites.deco.Mushroom14.default(ctx, x+64, y+64, {w: 64, h: 64}),
        (ctx, x, y) => Sprites.deco.Mushroom15.default(ctx, x+64, y+64, {w: 64, h: 64}),
        (ctx, x, y) => Sprites.deco.Mushroom16.default(ctx, x+64, y+32, {w: 64, h: 128}),
        (ctx, x, y) => Sprites.deco.Mushroom17.default(ctx, x+64, y+32, {w: 64, h: 128}),
        (ctx, x, y) => Sprites.deco.Mushroom18.default(ctx, x, y, {w: 192, h: 192}),
        (ctx, x, y) => Sprites.effet.Explosion.default(ctx, x, y, {w: 192, h: 192}),
        (ctx, x, y) => Sprites.effet.Fireball.fly(ctx, x, y, {w: 192, h: 192}),
        (ctx, x, y) => Sprites.faction.pawn_blue.idle(ctx, x, y, {w: 128, h: 128}),
        (ctx, x, y) => Sprites.faction.pawn_blue.walk(ctx, x, y, {w: 192, h: 192}),
        (ctx, x, y) => Sprites.faction.pawn_blue.attack_hammer(ctx, x, y, {w: 192, h: 192}),
        (ctx, x, y) => Sprites.faction.pawn_blue.attack_axe(ctx, x, y, {w: 192, h: 192}),
        (ctx, x, y) => Sprites.faction.pawn_blue.idle_ham_up(ctx, x, y, {w: 192, h: 192}),
        (ctx, x, y) => Sprites.faction.pawn_blue.walk_ham_up(ctx, x, y, {w: 192, h: 192}),
        (ctx, x, y) => Sprites.faction.pawn_red.idle(ctx, x, y, {w: 192, h: 192}),
        (ctx, x, y) => Sprites.faction.pawn_red.walk(ctx, x, y, {w: 192, h: 192}),
        (ctx, x, y) => Sprites.faction.pawn_red.attack_hammer(ctx, x, y, {w: 192, h: 192}),
        (ctx, x, y) => Sprites.faction.pawn_red.attack_axe(ctx, x, y, {w: 192, h: 192}),
        (ctx, x, y) => Sprites.faction.pawn_red.idle_ham_up(ctx, x, y, {w: 192, h: 192}),
        (ctx, x, y) => Sprites.faction.pawn_red.walk_ham_up(ctx, x, y, {w: 192, h: 192}),
        (ctx, x, y) => Sprites.faction.pawn_yellow.idle(ctx, x, y, {w: 192, h: 192}),
        (ctx, x, y) => Sprites.faction.pawn_yellow.walk(ctx, x, y, {w: 192, h: 192}),
        (ctx, x, y) => Sprites.faction.pawn_yellow.attack_hammer(ctx, x, y, {w: 192, h: 192}),
        (ctx, x, y) => Sprites.faction.pawn_yellow.attack_axe(ctx, x, y, {w: 192, h: 192}),
        (ctx, x, y) => Sprites.faction.pawn_yellow.idle_ham_up(ctx, x, y, {w: 192, h: 192}),
        (ctx, x, y) => Sprites.faction.pawn_yellow.walk_ham_up(ctx, x, y, {w: 192, h: 192}),
        (ctx, x, y) => Sprites.faction.warrior_blue.idle(ctx, x, y, {w: 192, h: 192}),
        (ctx, x, y) => Sprites.faction.warrior_blue.walk(ctx, x, y, {w: 192, h: 192}),
        (ctx, x, y) => Sprites.faction.warrior_blue.attack_side_down(ctx, x, y, {w: 192, h: 192}),
        (ctx, x, y) => Sprites.faction.warrior_blue.attack_side_up(ctx, x, y, {w: 192, h: 192}),
        (ctx, x, y) => Sprites.faction.warrior_blue.attack_front_left(ctx, x, y, {w: 192, h: 192}),
        (ctx, x, y) => Sprites.faction.warrior_blue.attack_front_right(ctx, x, y, {w: 192, h: 192}),
        (ctx, x, y) => Sprites.faction.warrior_blue.attack_back_right(ctx, x, y, {w: 192, h: 192}),
        (ctx, x, y) => Sprites.faction.warrior_blue.attack_back_left(ctx, x, y, {w: 192, h: 192}),
        (ctx, x, y) => Sprites.faction.warrior_purple.idle(ctx, x, y, {w: 192, h: 192}),
        (ctx, x, y) => Sprites.faction.warrior_purple.walk(ctx, x, y, {w: 192, h: 192}),
        (ctx, x, y) => Sprites.faction.warrior_purple.attack_side_down(ctx, x, y, {w: 192, h: 192}),
        (ctx, x, y) => Sprites.faction.warrior_purple.attack_side_up(ctx, x, y, {w: 192, h: 192}),
        (ctx, x, y) => Sprites.faction.warrior_purple.attack_front_left(ctx, x, y, {w: 192, h: 192}),
        (ctx, x, y) => Sprites.faction.warrior_purple.attack_front_right(ctx, x, y, {w: 192, h: 192}),
        (ctx, x, y) => Sprites.faction.warrior_purple.attack_back_right(ctx, x, y, {w: 192, h: 192}),
        (ctx, x, y) => Sprites.faction.warrior_purple.attack_back_left(ctx, x, y, {w: 192, h: 192}),
        (ctx, x, y) => Sprites.faction.warrior_red.idle(ctx, x, y, {w: 192, h: 192}),
        (ctx, x, y) => Sprites.faction.warrior_red.walk(ctx, x, y, {w: 192, h: 192}),
        (ctx, x, y) => Sprites.faction.warrior_red.attack_side_down(ctx, x, y, {w: 192, h: 192}),
        (ctx, x, y) => Sprites.faction.warrior_red.attack_side_up(ctx, x, y, {w: 192, h: 192}),
        (ctx, x, y) => Sprites.faction.warrior_red.attack_front_left(ctx, x, y, {w: 192, h: 192}),
        (ctx, x, y) => Sprites.faction.warrior_red.attack_front_right(ctx, x, y, {w: 192, h: 192}),
        (ctx, x, y) => Sprites.faction.warrior_red.attack_back_right(ctx, x, y, {w: 192, h: 192}),
        (ctx, x, y) => Sprites.faction.warrior_red.attack_back_left(ctx, x, y, {w: 192, h: 192}),
        (ctx, x, y) => Sprites.faction.warrior_yellow.idle(ctx, x, y, {w: 192, h: 192}),
        (ctx, x, y) => Sprites.faction.warrior_yellow.walk(ctx, x, y, {w: 192, h: 192}),
        (ctx, x, y) => Sprites.faction.warrior_yellow.attack_side_down(ctx, x, y, {w: 192, h: 192}),
        (ctx, x, y) => Sprites.faction.warrior_yellow.attack_side_up(ctx, x, y, {w: 192, h: 192}),
        (ctx, x, y) => Sprites.faction.warrior_yellow.attack_front_left(ctx, x, y, {w: 192, h: 192}),
        (ctx, x, y) => Sprites.faction.warrior_yellow.attack_front_right(ctx, x, y, {w: 192, h: 192}),
        (ctx, x, y) => Sprites.faction.warrior_yellow.attack_back_right(ctx, x, y, {w: 192, h: 192}),
        (ctx, x, y) => Sprites.faction.warrior_yellow.attack_back_left(ctx, x, y, {w: 192, h: 192}),
        (ctx, x, y) => Sprites.terrain.Ground_Elevation.left_top(ctx, x+64, y+64, {w: 64, h: 64}),
        (ctx, x, y) => Sprites.terrain.Ground_Elevation.middle_top(ctx, x+64, y+64, {w: 64, h: 64}),
        (ctx, x, y) => Sprites.terrain.Ground_Elevation.right_top(ctx, x+64, y+64, {w: 64, h: 64}),
        (ctx, x, y) => Sprites.terrain.Ground_Elevation.one_top(ctx, x+64, y+64, {w: 64, h: 64}),
        (ctx, x, y) => Sprites.terrain.Ground_Elevation.left_middle(ctx, x+64, y+64, {w: 64, h: 64}),
        (ctx, x, y) => Sprites.terrain.Ground_Elevation.middle_middle(ctx, x+64, y+64, {w: 64, h: 64}),
        (ctx, x, y) => Sprites.terrain.Ground_Elevation.right_middle(ctx, x+64, y+64, {w: 64, h: 64}),
        (ctx, x, y) => Sprites.terrain.Ground_Elevation.one_middle(ctx, x+64, y+64, {w: 64, h: 64}),
        (ctx, x, y) => Sprites.terrain.Ground_Elevation.left_bottom(ctx, x+64, y+64, {w: 64, h: 64}),
        (ctx, x, y) => Sprites.terrain.Ground_Elevation.middle_bottom(ctx, x+64, y+64, {w: 64, h: 64}),
        (ctx, x, y) => Sprites.terrain.Ground_Elevation.right_bottom(ctx, x+64, y+64, {w: 64, h: 64}),
        (ctx, x, y) => Sprites.terrain.Ground_Elevation.one_bottom(ctx, x+64, y+64, {w: 64, h: 64}),
        (ctx, x, y) => Sprites.terrain.Ground_Elevation.left_face(ctx, x+64, y+64, {w: 64, h: 64}),
        (ctx, x, y) => Sprites.terrain.Ground_Elevation.middle_face(ctx, x+64, y+64, {w: 64, h: 64}),
        (ctx, x, y) => Sprites.terrain.Ground_Elevation.right_face(ctx, x+64, y+64, {w: 64, h: 64}),
        (ctx, x, y) => Sprites.terrain.Ground_Elevation.one_face(ctx, x+64, y+64, {w: 64, h: 64}),
        (ctx, x, y) => Sprites.terrain.Ground_Elevation.left_one(ctx, x+64, y+64, {w: 64, h: 64}),
        (ctx, x, y) => Sprites.terrain.Ground_Elevation.middle_one(ctx, x+64, y+64, {w: 64, h: 64}),
        (ctx, x, y) => Sprites.terrain.Ground_Elevation.right_one(ctx, x+64, y+64, {w: 64, h: 64}),
        (ctx, x, y) => Sprites.terrain.Ground_Elevation.one_one(ctx, x+64, y+64, {w: 64, h: 64}),
        (ctx, x, y) => Sprites.terrain.Ground_Elevation.left_face_2(ctx, x+64, y+64, {w: 64, h: 64}),
        (ctx, x, y) => Sprites.terrain.Ground_Elevation.middle_face_2(ctx, x+64, y+64, {w: 64, h: 64}),
        (ctx, x, y) => Sprites.terrain.Ground_Elevation.right_face_2(ctx, x+64, y+64, {w: 64, h: 64}),
        (ctx, x, y) => Sprites.terrain.Ground_Elevation.one_face_2(ctx, x+64, y+64, {w: 64, h: 64}),
        (ctx, x, y) => Sprites.terrain.Ground_Flat.left_horizontal(ctx, x+64, y+64, {w: 64, h: 64}),
        (ctx, x, y) => Sprites.terrain.Ground_Flat.middle_horizontal(ctx, x+64, y+64, {w: 64, h: 64}),
        (ctx, x, y) => Sprites.terrain.Ground_Flat.right_horizontal(ctx, x+64, y+64, {w: 64, h: 64}),
        (ctx, x, y) => Sprites.terrain.Ground_Flat.top_vertical(ctx, x+64, y+64, {w: 64, h: 64}),
        (ctx, x, y) => Sprites.terrain.Ground_Flat.middle_vertical(ctx, x+64, y+64, {w: 64, h: 64}),
        (ctx, x, y) => Sprites.terrain.Ground_Flat.bottom_vertical(ctx, x+64, y+64, {w: 64, h: 64}),
        (ctx, x, y) => Sprites.terrain.Ground_Flat.log_1(ctx, x, y, {w: 128, h: 128}),
        (ctx, x, y) => Sprites.terrain.Ground_Flat.log_2(ctx, x, y, {w: 128, h: 128}),
        (ctx, x, y) => Sprites.terrain.Ground_Flat.log_3(ctx, x, y, {w: 128, h: 128})
    ];

// --- Paramètres de la grille ---
    const CELL_W = 192, CELL_H = 192;
    const GRID_COLS = 8; // par exemple, 8 colonnes

// --- Fonction d'affichage automatique de la grille ---
    // On prépare une "cellule" pour chaque sprite
    const cells = spriteDraws.map(drawFn => ({draw: drawFn}));

// Plus tard, dans renderSpritesGrid
    function renderSpritesGrid(ctx) {
        ctx.clearRect(0, 0, ctx.canvas.width, ctx.canvas.height);
        cells.forEach((cell, i) => {
            const col = i % GRID_COLS;
            const row = Math.floor(i / GRID_COLS);
            const x = col * CELL_W;
            const y = row * CELL_H;
           // console.log(x)
            if (x !==undefined) {
            cell.draw(ctx, x, y); // Appelle toujours la même fonction pour la même cellule
            } else {
                console.error("Variable 'f' is undefined or missing 'x' property.");
                // Handle the error appropriately, perhaps skip drawing
            }
                // Optionnel : bordure
            ctx.save();
            ctx.strokeStyle = "#888";
            ctx.lineWidth = 2;
            ctx.strokeRect(x, y, CELL_W, CELL_H);
            ctx.restore();
        });
    }
        function animate() {
            renderSpritesGrid(ctx);
            requestAnimationFrame(animate);
        }

        animate();

})();

// --- Boucle d'animation pour les sprites animés ---
    const ctx = document.getElementById('game').getContext('2d');


